package ch.frankel.blog.spring.authoring.custom;

import static org.junit.Assert.assertNotNull;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = "classpath:beans-test.xml")
public class CustomNamespaceIntegrationTest {

	@Resource
	@Qualifier("java.lang.Object#0")
	private Object foo;
	
	@Resource
	private Object bar;
	
	/**
	 * Test the &lt;custom:foo /&gt; definition.
	 */
	@Test
	public void testSimplestBeanDefinitionParser() {
		
		assertNotNull(foo);
	}
	
	/**
	 * Test the &lt;custom:bar&gt; definition.
	 */
	@Test
	public void testSimpleBeanDefinitionParser() {
		
		assertNotNull(bar);
	}
}
